<?php
include_once 'db.php';
session_start();

header('Content-Type: application/json');

// Retrieve and decode JSON input
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);

// Extract the order ID from the decoded data
$orderid = $data['order_id'] ?? ''; 

if (empty($orderid)) {
    echo json_encode(['error' => 'Order ID is required']);
    exit();
}

// Query to fetch order data
$orderDataQuery = "SELECT * FROM order_data WHERE Order_id = '$orderid' AND Delete_status = 0";
$orderDataResult = mysqli_query($conn, $orderDataQuery);

if (!$orderDataResult) {
    echo json_encode(['error' => 'Failed to fetch order data: ' . mysqli_error($conn)]);
    exit();
}

$orders = [];

while ($row = mysqli_fetch_assoc($orderDataResult)) {
    $productid = $row['Product_id'];
    $productQuery = "SELECT Product_id, Product_name,Product_image FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }

    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';
    $productimage = $product['Product_image']?? '';

    // Add order data to the array
    $orders[] = [
        'productid' => $productid,
        'productname' => $productname,
        'productimage' => $productimage,
        'mrp' => $row['MRP'],
        'saleprice' => $row['Selling_price'],
        'discountvalue' => $row['discount'],
        'discountpercentage' => $row['Discount_percentage'],
        'qty' => $row['qty'],
        'amount' => $row['Product_total'],
        'taxvalue' => $row['Tax'],
        'taxpercentage' => $row['Tax_percentage'],
        'salepricetax' => $row['salepricetax']
    ];
}

// Store the fetched data in the session
$_SESSION['order_data'] = $orders;

echo json_encode(['status' => 'success', 'data' => $orders]);

// Close the database connection
mysqli_close($conn);
?>
